Define CONFIG = 0x3f50



'program GCA186
'railroad crossing controller for two directions

'program option":
'program = 0  idle task
'_         1  LEDS START FLASHING FOR 1.5 SECS AND SOUND IS SWItched on after time out program 2
'_         2  BARRIERS going down, wen down program 3
'_         3  waiting for counting down to zero, when zero program 4
'_         4  barriers going up, when up > program 5
'_         5  relay off, flashing off, waiting for last sensor to count tot zero, then program = 0

'-    Version 3 with PIC16F688 processor
'- this version uses potmeter for setting delay pre-barrier-down time amd servo limit positions.
'- Activating jumper will enable to adjust the current position of barriers
'- P1 (barriers up position)  and P3 (pre-barrier-down time) are only active when barriers are in reset mode
'- P2 is on;y active when barriers are in down position
'- jumper on, the barrier function are on hold, no magnets are sensed
'- do Not forget to take off jumper after adjusting !!!


TRISA = %11111111
TRISC = %11100000
PORTC = %00011000
PORTA = 255
AllDigital
ANSEL = %00000111
Symbol hall_a = RA5
Symbol hall_b = RA4
Symbol hall_c = RA3
Symbol hall_d = RC5
Symbol servo_1 = RC3
Symbol servo_2 = RC4
Symbol pgm_mode = RC2
Symbol flash_1 = RC1
Symbol flash_2 = RC0

Dim flashtime As Byte
Dim flashdelay As Byte
Dim servo_value As Word
Dim min_servo As Word
Dim old_min_servo As Word
Dim max_servo As Word
Dim old_max_servo As Word
Dim direction As Byte
Dim old_hall_a As Bit
Dim old_hall_b As Bit
Dim old_hall_c As Bit
Dim old_hall_d As Bit
Dim count_enter As Byte
Dim count_exit As Byte
Dim program As Byte
Dim end_reached As Bit
Dim advalue As Word  'value from adconversion
Dim time_before_barriers_down As Byte
Dim old_time_before_barriers_down As Byte
Dim dummy As Byte

servo_1 = 1
servo_2 = 1
servo_value = max_servo  'start in barrier up position
program = 0
old_hall_a = 0
old_hall_b = 0
old_hall_c = 0
old_hall_d = 0
count_exit = 0
count_enter = 0
flash_1 = 1
flash_2 = 1
flashdelay = 0
flashtime = 0
Read 0, min_servo.LB
Read 1, min_servo.HB
If min_servo > 1600 Then
	min_servo = 400
Endif
old_min_servo = min_servo
Read 2, max_servo.LB
Read 3, max_servo.HB
If max_servo > 1600 Then
	max_servo = 1600
Endif
old_max_servo = max_servo
Read 4, time_before_barriers_down
If time_before_barriers_down > 50 Then
	time_before_barriers_down = 12
Endif
old_time_before_barriers_down = time_before_barriers_down
WaitMs 1000
main:
	For dummy = 1 To 15
		Gosub check_sensors
		WaitMs 1
	Next dummy
	Select Case program
	Case 0  'idle task
		count_enter = 0
		count_exit = 0
		end_reached = 1  'barriers are up
		If pgm_mode = 0 Then
			Gosub set_pos_barrier_up
			Gosub set_wait_time
		Endif
		Call flashes(0)
		flashtime = 0
		flashdelay = 0
		direction = 0  'direction 1: first sensor =a  >>  direction =2 : first sensor = d
	Case 1  'activate flashing leds and soundrelay
		Call flashes(1)
		If flashtime > time_before_barriers_down Then  'enough flashing? start program 2
			program = 2
		Endif

	Case 2  'barriers down
		Call barrier_set(0, min_servo)
		Call flashes(1)
		If end_reached = 0 Then
			program = 3
		Endif
	
	Case 3  'waiting for counting down count_enter
		If pgm_mode = 0 Then
			Gosub set_pos_barrier_down
		Endif
		Call flashes(1)
		If count_enter = 0 Then
			program = 4
		Endif
	Case 4  'barriers going up
		Call barrier_set(1, max_servo)
		Call flashes(1)
		If end_reached = 1 Then
			program = 5
		Endif
	Case 5  'waiting for count down count_exit
		Call flashes(1)
		If count_exit = 0 Then
			program = 0
			Call flashes(0)
			WaitMs 3000
		Endif
	Case Else
	EndSelect
		
	
Goto main
End                                               
Proc flashes(onoff As Bit)
	If onoff = 1 Then
		If flashdelay < 20 Then
			flashdelay = flashdelay + 1
		Else
			If flash_1 = 0 Then  'always keep 1 flash ON to keep relay activated.
				flash_1 = 1
				flash_2 = 0
			Else
				flash_2 = 1
				flash_1 = 0
			Endif
			flashdelay = 0
			flashtime = flashtime + 1
		Endif
	Else
		flash_1 = 0  'leds off
		flash_2 = 0
		flashtime = 0
		flashdelay = 0
	Endif
End Proc                                          

check_sensors:
	Select Case direction
	Case 0  'program = also still 0!
		If hall_a = 0 Then
			If old_hall_a = 0 Then
				program = 1
				direction = 1
				count_enter = 1
				count_exit = 1
				old_hall_a = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_a = 0
		Endif
		If hall_d = 0 Then
			If old_hall_d = 0 Then
				program = 1
				direction = 2  'approach from other side
				count_enter = 1
				count_exit = 1
				old_hall_d = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_d = 0
		Endif

	Case 1  'forward from a to d
		If hall_a = 0 Then
			If old_hall_a = 0 Then
				count_enter = count_enter + 1
				count_exit = count_exit + 1
				old_hall_a = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_a = 0
		Endif
		If hall_c = 0 Then
			If old_hall_c = 0 Then
				If count_enter > 0 Then
					count_enter = count_enter - 1
					old_hall_c = 1  'avoid the same been seen more than once in ome pass
				Endif
			Endif
		Else
			old_hall_c = 0
		Endif
		If hall_d = 0 Then
			If old_hall_d = 0 Then
				If count_exit > 0 Then
					count_exit = count_exit - 1
					old_hall_d = 1  'avoid the same been seen more than once in ome pass
				Endif
			Endif
		Else
			old_hall_d = 0
		Endif
	Case Else  'reverse from d to a
		If hall_d = 0 Then
			If old_hall_d = 0 Then
				count_enter = count_enter + 1
				count_exit = count_exit + 1
				old_hall_d = 1  'avoid the same been seen more than once in ome pass
			Endif
		Else
			old_hall_d = 0
		Endif
		If hall_b = 0 Then
			If old_hall_b = 0 Then
				If count_enter > 0 Then
					count_enter = count_enter - 1
					old_hall_b = 1
				Endif
			Endif
		Else
			old_hall_b = 0
		Endif
		If hall_a = 0 Then
			If old_hall_a = 0 Then
				If count_exit > 0 Then
					count_exit = count_exit - 1
					old_hall_a = 1
				Endif
			Endif
		Else
			old_hall_a = 0
		Endif
	EndSelect
	
Return                                            

Proc barrier_set(pos_dir As Bit, position As Word)
	If pos_dir = 0 Then  'barriers go down
		If servo_value < position Then
			servo_value = servo_value - 3
			Call set_servo()
		Else
			end_reached = 1
			servo_1 = 1
			servo_2 = 1
		Endif
	Else
		If servo_value > position Then
			servo_value = servo_value + 3
			Call set_servo()
		Else
			end_reached = 1
			servo_1 = 1
			servo_2 = 1
		Endif
	Endif
End Proc                                          


Proc set_servo()
	servo_1 = 1
	WaitUs servo_value
	servo_1 = 0
	servo_2 = 1
	WaitUs servo_value
	servo_2 = 0
End Proc                                          

set_pos_barrier_up:
	Adcin 0, advalue  'measure pot 1 for up position
	max_servo = advalue + 400
	While servo_value < max_servo
		servo_value = servo_value + 1
		servo_1 = 1
		servo_2 = 1
		WaitUs servo_value
		servo_1 = 0
		servo_2 = 0
		WaitMs 15
	Wend
	While servo_value < max_servo
		servo_value = servo_value - 1
		servo_1 = 1
		servo_2 = 1
		WaitUs servo_value
		servo_1 = 0
		servo_2 = 0
		WaitMs 15
	Wend
	If old_max_servo <> max_servo Then
		Write 2, max_servo.LB
		Write 3, max_servo.HB
		old_max_servo = max_servo
	Endif

Return                                            

set_pos_barrier_down:
	Adcin 1, advalue  'measure pot 2 for down position
	min_servo = advalue + 400
	If servo_value < min_servo Then
		While servo_value < min_servo
			servo_value = servo_value + 1
			servo_1 = 1
			servo_2 = 1
			WaitUs servo_value
			servo_1 = 0
			servo_2 = 0
			WaitMs 15
		Wend
		old_min_servo = min_servo
	Else
		While servo_value > min_servo
			servo_value = servo_value - 1
			servo_1 = 1
			servo_2 = 1
			WaitUs servo_value
			servo_1 = 0
			servo_2 = 0
			WaitMs 15
		Wend
	Endif
	If old_min_servo <> min_servo Then
		Write 0, min_servo.LB
		Write 1, min_servo.HB
		old_min_servo = min_servo
	Endif
Return                                            

set_wait_time:
	Adcin 2, advalue  'read time_before_barriers_down
	advalue = advalue / 20
	time_before_barriers_down = advalue.LB
	If old_time_before_barriers_down <> time_before_barriers_down Then
		Write 4, time_before_barriers_down
		old_time_before_barriers_down = time_before_barriers_down
	Endif
Return                                            